<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cart extends Model 
{

    protected $table = 'cart';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $visible = array('id', 'session');

    public function cartItems()
    {
        return $this->hasMany('CartItems', 'cart_id');
    }

    public function orders()
    {
        return $this->hasMany('Order', 'cart_id');
    }

}